import pandas as pd   
import pickle
from decision_company import read_csv_file, fetch_column, calculate_quantile
  
# Load the dataset using the custom function  
credit_customers = read_csv_file("credit_customers.csv") 
  
# Calculate the 75th percentile for credit_amount and duration  
credit_amount_column = fetch_column(credit_customers, 'credit_amount')  
duration_column = fetch_column(credit_customers, 'duration')  
  
credit_amount_75th = calculate_quantile(credit_amount_column, 0.75)  
duration_75th = calculate_quantile(duration_column, 0.75)  
  
print(f"credit_amount_75th: {credit_amount_75th}, duration_75th: {duration_75th}")  
pickle.dump(credit_amount_75th, open("./ref_result/credit_amount_75th.pkl","wb"))
pickle.dump(duration_75th, open("./ref_result/duration_75th.pkl","wb"))

  